/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class TFontManager {
    private static final String TTF_FONT_FILE = "VL-Gothic-Regular.ttf";
    private static final String DEFAULT_FONT_NAME = "Monospaced";
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final float DEFAULT_FONT_SIZE = 16.0f;
    private static Font _font;

    private TFontManager() {
    }

    public static Font getDefaultFont() {
        if (_font == null) {
            TFontManager.loadFont();
        }
        return _font;
    }

    public static boolean useTrueTypeFont() {
        if (TFontManager.isWindowsOS()) {
            // empty if block
        }
        return true;
    }

    private static void loadFont() {
        if (TFontManager.isWindowsOS()) {
            // empty if block
        }
        URL uRL = TFontManager.class.getResource(TTF_FONT_FILE);
        _font = TFontManager.getFontFromFileURL(uRL).deriveFont(16.0f);
    }

    private static boolean isWindowsOS() {
        String string = System.getProperty("os.name");
        return string.toUpperCase().startsWith("WINDOWS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font getFontFromFileURL(URL uRL) {
        InputStream inputStream = null;
        try {
            Font font;
            inputStream = uRL.openStream();
            Font font2 = font = Font.createFont(0, inputStream);
            return font2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (FontFormatException fontFormatException) {
            fontFormatException.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return new Font(DEFAULT_FONT_NAME, 0, 16);
    }
}

