/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import java.awt.event.KeyEvent;
import java.util.List;
import tuttt.TGlobal;
import tuttt.TNIException;
import tuttt.TNKeyInputHandler;
import tuttt.TTApplication;
import tuttt.TTMenuInterpreter;
import tuttt.TTestInterpreter;
import tuttt.TTokenizer;

public class TInterpreter {
    private static final String KEY_CHARS = "qwertyuiopasdfghjkl;zxcvbnm,./1234567890";
    protected TTApplication _application;
    protected TTokenizer _tokenizer;
    protected int _lessonNo;
    protected int _sectionNo;
    protected boolean _running = false;

    public TInterpreter(TTApplication tTApplication, String string) {
        this._application = tTApplication;
        this._tokenizer = new TTokenizer(string, tTApplication.isAppletMode());
    }

    public TInterpreter(TTApplication tTApplication, TTokenizer tTokenizer) {
        this._application = tTApplication;
        this._tokenizer = tTokenizer;
    }

    public void run(int n, int n2) {
        this._running = true;
        this._lessonNo = n;
        this._sectionNo = n2;
        if (n2 > 0 && !this.goToSection(n2)) {
            throw new TNIException("\u5bfe\u5fdc\u3059\u308b !SECTION \u304c\u3042\u308a\u307e\u305b\u3093\u3002" + this.dump());
        }
        this._tokenizer.next();
        while (this._running) {
            this.processCommand();
        }
        if (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.END)) {
            return;
        }
    }

    public boolean isEnd() {
        return this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.END);
    }

    private boolean goToSection(int n) {
        while (!this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.END)) {
            if (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.COMMAND) && this._tokenizer.tokenIs("!SECTION")) {
                this._tokenizer.next();
                String string = this._tokenizer.getToken();
                try {
                    if (n == Integer.parseInt(string)) {
                        this._sectionNo = n;
                        this._tokenizer.saveRollBackPoint();
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TNIException(string + " \u306f\u6570\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + this.dump());
                }
            }
            this._tokenizer.next();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processCommand() {
        if (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.END)) {
            this._running = false;
            return;
        }
        if (!this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.COMMAND)) throw new TNIException("\u30b3\u30de\u30f3\u30c9\u304c\u6765\u308b\u3079\u304d\u6240\u306b\u3001\u305d\u308c\u4ee5\u5916\u306e\u3082\u306e\u304c\u66f8\u304b\u308c\u3066\u3044\u307e\u3059\u3002" + this.dump());
        if (this._tokenizer.tokenIs("!SET")) {
            this.set();
            return;
        } else if (this._tokenizer.tokenIs("!LOAD")) {
            this.load();
            return;
        } else if (this._tokenizer.tokenIs("!MENU")) {
            this.menu();
            return;
        } else if (this._tokenizer.tokenIs("!TEST")) {
            this.test();
            return;
        } else if (this._tokenizer.tokenIs("!SECTION")) {
            this.section();
            return;
        } else if (this._tokenizer.tokenIs("!DISP")) {
            this.display();
            return;
        } else if (this._tokenizer.tokenIs("!DISP_HAND")) {
            this.displayHand();
            return;
        } else if (this._tokenizer.tokenIs("!PAUSE")) {
            this.pause();
            return;
        } else if (this._tokenizer.tokenIs("!PAUSE_B")) {
            this.pauseCanback();
            return;
        } else if (this._tokenizer.tokenIs("!LONG_PAUSE")) {
            this.longPause();
            return;
        } else {
            if (!this._tokenizer.tokenIs("!LONG_PAUSE_B")) throw new TNIException("\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u306a\u3044\u30b3\u30de\u30f3\u30c9\u3067\u3059\u3002" + this.dump());
            this.longPauseCanback();
        }
    }

    private void set() {
        this._tokenizer.next();
        if (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.SYMBOL)) {
            String string = this._tokenizer.getToken();
            TGlobal.remove(string);
            this._tokenizer.next();
            while (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.STRING) || this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.NUMBER) || this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.SYMBOL)) {
                TGlobal.put(string, this._tokenizer.getToken());
                this._tokenizer.next();
            }
        } else {
            throw new TNIException("!SET \u30b3\u30de\u30f3\u30c9\u306e\u5909\u6570\u540d\u306e\u578b\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059\u3002" + this.dump());
        }
    }

    private void load() {
        this._tokenizer.next();
        if (!this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.STRING)) {
            throw new TNIException("load \u30b3\u30de\u30f3\u30c9\u306e\u4f7f\u7528\u6cd5\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002" + this.dump());
        }
        new TInterpreter(this._application, this._tokenizer.getToken()).run(0, 0);
        this._tokenizer.next();
    }

    private void menu() {
        this.createMenuInterpreter().processCommand();
        this._tokenizer.next();
    }

    private void test() {
        if (!this.createTestInterpreter().processCommandTest()) {
            this._running = false;
        }
        this._tokenizer.next();
    }

    private void section() {
        this._tokenizer.next();
        String string = this._tokenizer.getToken();
        if (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.NUMBER)) {
            try {
                this._sectionNo = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TNIException(string + " \u306f\u6570\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + this.dump());
            }
        } else {
            throw new TNIException("!SECTION \u30b3\u30de\u30f3\u30c9\u306e\u4f7f\u7528\u6cd5\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059\u3002" + this.dump());
        }
        this._tokenizer.next();
    }

    private void display() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this._application.getWindow().clear();
        this._tokenizer.next();
        if (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.NUMBER)) {
            String string = this._tokenizer.getToken();
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TNIException(string + " \u306f\u6570\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + this.dump());
            }
            this._tokenizer.next();
            string = this._tokenizer.getToken();
            if (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.NUMBER)) {
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TNIException(string + " \u306f\u6570\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + this.dump());
                }
                this._tokenizer.next();
            } else {
                throw new TNIException("!DISP \u30b3\u30de\u30f3\u30c9\u306e y\u5ea7\u6a19\u306e\u6307\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002" + this.dump());
            }
        }
        while (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.STRING)) {
            int n4 = TGlobal.getInt("disp_x") + n2;
            int n5 = TGlobal.getInt("disp_y") + n3 + n;
            this._application.getWindow().moveTo(n4, n5);
            this._application.getWindow().drawString(this._tokenizer.getToken());
            this._tokenizer.next();
            ++n;
        }
        this.displayGuide();
        if (!this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.COMMAND)) {
            throw new TNIException("!DISP \u30b3\u30de\u30f3\u30c9\u306e\u8868\u8a18\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059\u3002" + this.dump());
        }
    }

    private void displayHand() {
        int n = 0;
        int n2 = 0;
        this._tokenizer.next();
        if (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.NUMBER)) {
            try {
                n = Integer.parseInt(this._tokenizer.getToken());
            }
            catch (NumberFormatException numberFormatException) {
                n = TGlobal.getInt("hand_x");
            }
            this._tokenizer.next();
            if (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.NUMBER)) {
                try {
                    n2 = Integer.parseInt(this._tokenizer.getToken());
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = n;
                }
                this._tokenizer.next();
            } else {
                n2 = n;
                n = TGlobal.getInt("hand_x");
            }
        } else {
            n = TGlobal.getInt("hand_x");
            n2 = TGlobal.getInt("hand_y");
        }
        this.displayHand(n, n2);
    }

    private void pause() {
        this._tokenizer.next();
        if (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.NUMBER)) {
            int n;
            try {
                n = Integer.parseInt(this._tokenizer.getToken());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n >= 0 && n < 60) {
                int n2 = TGlobal.getInt("pause_y");
                this._application.getWindow().moveTo(0, n2 - 1);
                this._application.getWindow().drawString("\n");
                try {
                    Thread.sleep((long)n * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                throw new TNIException("!PAUSE \u306e\u6642\u9593\u304c\u59a5\u5f53\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + this.dump());
            }
            this._tokenizer.next();
        } else {
            this.pause(TGlobal.getString("pause_message"), false);
        }
    }

    private void pauseCanback() {
        this.pause(TGlobal.getString("pause_message_b"), true);
        this._tokenizer.next();
    }

    private void longPause() {
        this.longPause(TGlobal.getString("long_pause_message"), false);
        this._tokenizer.next();
    }

    private void longPauseCanback() {
        this.longPause(TGlobal.getString("long_pause_message_b"), true);
        this._tokenizer.next();
    }

    private TTMenuInterpreter createMenuInterpreter() {
        return new TTMenuInterpreter(this._application, this._tokenizer);
    }

    private TTestInterpreter createTestInterpreter() {
        TTestInterpreter tTestInterpreter = new TTestInterpreter(this._application, this._tokenizer, this._lessonNo, this._sectionNo);
        return tTestInterpreter;
    }

    protected void displayGuide() {
        this._application.getWindow().moveTo(60, 0);
        this._application.getWindow().drawString(TGlobal.getString("disp_message"));
    }

    protected void displayHand(int n, int n2) {
        List<String> list = TGlobal.getStrings("hand_pattern");
        for (int i = 0; i < list.size(); ++i) {
            this._application.getWindow().moveTo(TGlobal.getInt("hand_x"), n2 + i);
            String string = list.get(i);
            for (int j = 0; j < string.length(); ++j) {
                String string2 = string.substring(j, j + 1);
                if (KEY_CHARS.contains(string2)) {
                    if (TGlobal.getString("new").contains(string2)) {
                        this._application.getWindow().drawRevString(string2);
                        continue;
                    }
                    if (TGlobal.getString("learned").contains(string2)) {
                        this._application.getWindow().drawString(string2);
                        continue;
                    }
                    this._application.getWindow().drawString(" ");
                    continue;
                }
                this._application.getWindow().drawString(string2);
            }
        }
    }

    protected void pause(String string, boolean bl) {
        this._application.getWindow().moveYTo(TGlobal.getInt("pause_y"));
        this._application.getWindow().drawRevCenterString(string);
        KeyEvent keyEvent = this._application.getWindow().getInput();
        if (keyEvent == TNKeyInputHandler.TERMINATE_SIGNAL) {
            this._running = false;
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this._running = false;
                return;
            }
            case 8: 
            case 127: {
                if (bl) {
                    this.backward();
                    return;
                }
                this.pause(string, bl);
                break;
            }
            case 32: {
                this._tokenizer.saveRollBackPoint();
                break;
            }
            default: {
                this.pause(string, bl);
            }
        }
    }

    protected void longPause(String string, boolean bl) {
        List<String> list = TGlobal.getStrings("long_pause_window");
        block5: while (true) {
            int n;
            int n2 = TGlobal.getInt("long_pause_x");
            int n3 = TGlobal.getInt("long_pause_y");
            for (n = 0; n < list.size(); ++n) {
                this._application.getWindow().moveTo(n2, n3 + n);
                this._application.getWindow().drawString(list.get(n));
            }
            this._application.getWindow().moveYTo(n3 + 3);
            this._application.getWindow().drawRevCenterString(string);
            this._application.getWindow().moveTo(n2 + 5, n3 + 1);
            this._application.getWindow().moveCursor(n2 + 5, n3 + 1);
            n = 0;
            block7: while (true) {
                if (n >= TGlobal.getInt("long_pause_width")) continue block5;
                KeyEvent keyEvent = this._application.getWindow().getInput();
                if (keyEvent == TNKeyInputHandler.TERMINATE_SIGNAL) {
                    this._running = false;
                    return;
                }
                int n4 = keyEvent.getKeyCode();
                switch (n4) {
                    case 10: {
                        this._tokenizer.saveRollBackPoint();
                        return;
                    }
                    case 27: {
                        this._running = false;
                        return;
                    }
                    case 8: 
                    case 127: {
                        if (!bl) continue block7;
                        this.backward();
                        return;
                    }
                }
                char c = keyEvent.getKeyChar();
                if (c < ' ' || c > '\u007f') continue;
                String string2 = Character.toString(c);
                this._application.getWindow().forwardCursor(1);
                this._application.getWindow().drawString(string2);
                ++n;
            }
            break;
        }
    }

    protected void backward() {
        if (!this._tokenizer.doRollBack()) {
            this._running = false;
        } else {
            this._tokenizer.saveRollBackPoint();
        }
    }

    protected String dump() {
        return this._tokenizer.dump();
    }

    protected void goto_next() {
        this._tokenizer.next();
        while (!this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.COMMAND) && !this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.END)) {
            if (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.UNDEF)) {
                // empty if block
            }
            this._tokenizer.next();
        }
    }
}

