/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import tuttt.TGlobal;
import tuttt.TMenu;
import tuttt.TWindow;

public class TMenuView {
    private static final int MENU_HEIGHT = TGlobal.getInt("menu_height");
    private static final int MENU_START_LINE = TGlobal.getInt("menu_start_line");
    private static final int MENU_HEAD_X = 15;
    private static final int MENU_HEAD_Y = 6;
    private static final int MENU_CHAP_X = 6;
    private static final int MENU_CHAP_Y = 11;
    private static final int MENU_SEC_X = 52;
    private static final int MENU_SEC_WIDTH = 5;
    private TMenu _menu;
    private TWindow _window;
    private int _cursorX;
    private int _cursorY;

    public TMenuView(TMenu tMenu, TWindow tWindow) {
        this._menu = tMenu;
        this._window = tWindow;
    }

    public void setCursorX(int n) {
        this._cursorX = n;
    }

    public void setCursorY(int n) {
        this._cursorY = n;
    }

    public int getCursorX() {
        return this._cursorX;
    }

    public int getCursorY() {
        return this._cursorY;
    }

    public void reset() {
        this._cursorX = 0;
        this._cursorY = MENU_START_LINE - 1;
        this.redraw();
    }

    public void left() {
        if (this._cursorX > 0) {
            this.moveTo(this._cursorX - 1, this._cursorY);
        } else {
            this.moveTo(-1, this._cursorY);
            this.up();
        }
    }

    public void right() {
        if (this._cursorX < this._menu.getChapter(this._cursorY).getSectionSize() - 1) {
            this.moveTo(this._cursorX + 1, this._cursorY);
        } else {
            this.moveTo(0, this._cursorY);
            this.down();
        }
    }

    public void up() {
        int n = this._cursorY > 0 ? this._cursorY - 1 : this._menu.getChapterSize() - 1;
        int n2 = this._cursorX < 0 || this._cursorX > this._menu.getChapter(n).getSectionSize() - 1 ? this._menu.getChapter(n).getSectionSize() - 1 : this._cursorX;
        this.moveTo(n2, n);
    }

    public void down() {
        int n = this._cursorY < this._menu.getChapterSize() - 1 ? this._cursorY + 1 : 0;
        int n2 = this._cursorX < 0 || this._cursorX > this._menu.getChapter(n).getSectionSize() - 1 ? this._menu.getChapter(n).getSectionSize() - 1 : this._cursorX;
        this.moveTo(n2, n);
    }

    private void moveTo(int n, int n2) {
        if (n2 / MENU_HEIGHT != this._cursorY / MENU_HEIGHT) {
            this._cursorX = n;
            this._cursorY = n2;
            this.redraw();
        } else {
            if (n2 != this._cursorY) {
                this.drawChapterTitle(this._cursorY);
                this.drawChapterTitleRev(n2);
            }
            this.drawSectionTitle(this._cursorX, this._cursorY);
            this.drawSectionTitleRev(n, n2);
            this._cursorX = n;
            this._cursorY = n2;
        }
    }

    public void redraw() {
        int n;
        this._window.clear();
        for (n = 0; n < this._menu.getMessageSize(); ++n) {
            this._window.moveTo(15, 6 + n);
            this._window.drawRevCenterString(this._menu.getMessage(n));
        }
        for (int i = n = this._cursorY / MENU_HEIGHT * MENU_HEIGHT; i < this._menu.getChapterSize() && i < n + MENU_HEIGHT; ++i) {
            if (i == this._cursorY) {
                this.drawChapterTitleRev(i);
            } else {
                this.drawChapterTitle(i);
            }
            for (int j = 0; j < this._menu.getChapter(i).getSectionSize(); ++j) {
                if (i == this._cursorY && j == this._cursorX) {
                    this.drawSectionTitleRev(j, i);
                    continue;
                }
                this.drawSectionTitle(j, i);
            }
        }
    }

    private void drawChapterTitle(int n) {
        this.moveToChapterTitlePosition(n);
        String string = this._menu.getChapter(n).getTitle();
        this._window.drawString(string);
    }

    private void drawChapterTitleRev(int n) {
        this.moveToChapterTitlePosition(n);
        String string = this._menu.getChapter(n).getTitle();
        this._window.drawRevString(string);
    }

    private void moveToChapterTitlePosition(int n) {
        int n2 = 6;
        int n3 = 11 + n % MENU_HEIGHT;
        this._window.moveTo(n2, n3);
    }

    private void drawSectionTitle(int n, int n2) {
        if (n >= 0) {
            this.moveToSectionTitlePosition(n, n2);
            String string = this._menu.getChapter(n2).getSection(n);
            this._window.drawString(string);
        }
    }

    private void drawSectionTitleRev(int n, int n2) {
        if (n >= 0) {
            this.moveToSectionTitlePosition(n, n2);
            String string = this._menu.getChapter(n2).getSection(n);
            this._window.drawRevString(string);
        }
    }

    private void moveToSectionTitlePosition(int n, int n2) {
        int n3 = 52 + 5 * n;
        int n4 = 11 + n2 % MENU_HEIGHT;
        this._window.moveTo(n3, n4);
    }
}

