/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import tuttt.TWindow;

public class TNKeyInputHandler {
    public static final KeyEvent TERMINATE_SIGNAL = new KeyEvent(new JButton(), -1, 0L, -1, -1, '0');
    private TWindow _window;
    private KeyEvent _keyEvent;
    private boolean _waitInput = true;
    private boolean _isShutdown = false;

    public TNKeyInputHandler(TWindow tWindow) {
        this._window = tWindow;
    }

    public KeyAdapter createKeyAdapter() {
        return new TKeyAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyEvent getInput() {
        if (this._isShutdown) {
            return TERMINATE_SIGNAL;
        }
        TNKeyInputHandler tNKeyInputHandler = this;
        synchronized (tNKeyInputHandler) {
            while (this._waitInput) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return this.createNullKeyEvent();
                }
            }
        }
        this._waitInput = true;
        return this._keyEvent;
    }

    private KeyEvent createNullKeyEvent() {
        return new KeyEvent(this._window, -1, 0L, -1, -1, '0');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this._waitInput = false;
        this._isShutdown = true;
        TNKeyInputHandler tNKeyInputHandler = this;
        synchronized (tNKeyInputHandler) {
            this._keyEvent = TERMINATE_SIGNAL;
            this.notifyAll();
        }
    }

    private class TKeyAdapter
    extends KeyAdapter {
        private TKeyAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent keyEvent) {
            TNKeyInputHandler.this._keyEvent = keyEvent;
            TNKeyInputHandler tNKeyInputHandler = TNKeyInputHandler.this;
            synchronized (tNKeyInputHandler) {
                TNKeyInputHandler.this.notifyAll();
                TNKeyInputHandler.this._waitInput = false;
            }
        }
    }
}

