/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import tuttt.TTApplication;

public class TTApplet
extends JApplet
implements ActionListener {
    private static final Color BACK_GROUND_COLOR = new Color(255, 199, 17, 238);
    private boolean _running = false;
    private JTextArea _topText = null;
    private JButton _bootButton = null;
    private JLabel _versionLabel = null;
    private LayoutManager layout = new FlowLayout(1, 5, 15);
    private String _moodleUserID;
    private String _moodleModuleID;
    private String _moodleReceiverURL;
    private String _moodleSignedJar;

    public void init() {
        this.setSize(280, 130);
        this.getContentPane().setLayout(this.layout);
        this.getContentPane().setBackground(BACK_GROUND_COLOR);
        if (this._topText == null) {
            this._topText = this.createTopLabelText();
        }
        this.getContentPane().add(this._topText);
        if (this._bootButton == null) {
            this._bootButton = this.createBootButton();
        }
        this.getContentPane().add(this._bootButton);
        if (this._versionLabel == null) {
            this._versionLabel = this.createVersionLabelText();
        }
        this.getContentPane().add(this._versionLabel);
        this._moodleUserID = this.getParameter("userId");
        this._moodleModuleID = this.getParameter("moduleId");
        this._moodleReceiverURL = this.getParameter("receiverURL");
        this._moodleSignedJar = this.getParameter("signedjar");
    }

    private JTextArea createTopLabelText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u4e0b\u306e\u30dc\u30bf\u30f3\u3092\u62bc\u3059\u3068\u5225\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u304c\u958b\u304d\u3001\n");
        stringBuffer.append(TTApplication.APPLICATION_NAME);
        stringBuffer.append("\u304c\u8d77\u52d5\u3057\u307e\u3059\u3002");
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Dialog", 1, 12));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setText(stringBuffer.toString());
        return jTextArea;
    }

    private JLabel createVersionLabelText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ver");
        stringBuffer.append("1.42");
        stringBuffer.append("<Build:");
        stringBuffer.append("2013051301");
        stringBuffer.append(">");
        JLabel jLabel = new JLabel(stringBuffer.toString());
        jLabel.setFont(new Font("Dialog", 1, 10));
        return jLabel;
    }

    private JButton createBootButton() {
        JButton jButton = new JButton();
        jButton.setPreferredSize(new Dimension(180, 30));
        jButton.addActionListener(this);
        return jButton;
    }

    public String getMoodleUserID() {
        return this._moodleUserID;
    }

    public String getMoodleModuleID() {
        return this._moodleModuleID;
    }

    public String getMoodleReceiverURL() {
        return this._moodleReceiverURL;
    }

    public String getMoodleSignedJar() {
        if (this._moodleSignedJar != null) {
            return this._moodleSignedJar;
        }
        return "false";
    }

    public void start() {
        this.updateButton();
    }

    public void notifyApplicationStart() {
        this._running = true;
        this.updateButton();
    }

    public void notifyApplicationExit() {
        this._running = false;
        this.updateButton();
    }

    private void updateButton() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!TTApplet.this._running) {
                    TTApplet.this._bootButton.setText("\u8d77\u52d5\u3059\u308b");
                    TTApplet.this._bootButton.setEnabled(true);
                } else {
                    TTApplet.this._bootButton.setText("\u8d77\u52d5\u4e2d");
                    TTApplet.this._bootButton.setEnabled(false);
                }
                TTApplet.this.repaint();
            }
        });
    }

    public void waitShutdown() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TTApplet.this._bootButton.setText("\u7d42\u4e86\u51e6\u7406\u4e2d\u3067\u3059");
                TTApplet.this._bootButton.setEnabled(false);
                TTApplet.this.repaint();
            }
        });
    }

    public boolean isRunning() {
        return this._running;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.notifyApplicationStart();
        Thread thread = new Thread(){

            public void run() {
                try {
                    TTApplication tTApplication = new TTApplication();
                    tTApplication.runAsApplet(TTApplet.this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    TTApplet.this.notifyApplicationExit();
                }
            }
        };
        thread.start();
    }

    public void callbackJavaScript(String string) {
        JSObject jSObject = JSObject.getWindow((Applet)this);
        try {
            jSObject.call(string, null);
        }
        catch (JSException jSException) {
            jSException.printStackTrace();
        }
    }
}

