/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import tuttt.TInterpreter;
import tuttt.TNIException;
import tuttt.TTApplet;
import tuttt.TWindow;

public class TTApplication {
    public static final boolean RECORDING = true;
    public static final boolean USE_FORCE_TTF = true;
    public static final TLangType LANG = DEFAULT_LANG = TLangType.JA;
    private static final TLangType DEFAULT_LANG;
    public static final String VERSION = "1.42";
    public static final String BUILD_ID = "2013051301";
    public static final String APPLICATION_NAME;
    private static final String APPLICATION_NAME_JA = "TUT\u30bf\u30c3\u30c1\u30bf\u30a4\u30d4\u30f3\u30b0 [Ja]";
    private static final String APPLICATION_NAME_EN = "TUT Touch Typing [En]";
    private TWindow _window;
    private TTApplet _applet;
    private boolean _isBootAsApplet;

    public static void main(String[] stringArray) {
        TTApplication tTApplication = new TTApplication();
        tTApplication.runAsApplication();
    }

    public void runAsApplication() {
        this._isBootAsApplet = false;
        this.run();
    }

    public void runAsApplet(TTApplet tTApplet) {
        this._applet = tTApplet;
        this._isBootAsApplet = true;
        this.run();
    }

    private String getRootFileName() {
        switch (LANG) {
            case JA: {
                return "ja/typing.txt";
            }
            case EN: {
                return "en/typing.txt";
            }
        }
        throw new IllegalStateException();
    }

    private void run() {
        this._window = new TWindow(this);
        this._window.open();
        try {
            TInterpreter tInterpreter = new TInterpreter(this, this.getRootFileName());
            tInterpreter.run(0, 0);
            if (this._isBootAsApplet) {
                this.exit();
                this._applet.notifyApplicationExit();
            } else {
                this.exit();
            }
            System.out.println("exit");
        }
        catch (TNIException tNIException) {
            this._window.error(tNIException.getMessage());
        }
    }

    public TWindow getWindow() {
        return this._window;
    }

    public boolean isAppletMode() {
        return this._isBootAsApplet;
    }

    public TTApplet getApplet() {
        if (!this.isAppletMode()) {
            throw new IllegalStateException("applet is null");
        }
        return this._applet;
    }

    public void exit() {
        if (this.isAppletMode()) {
            this._applet.waitShutdown();
            this._window.close();
        } else {
            System.exit(0);
        }
    }

    static {
        switch (LANG) {
            case JA: {
                APPLICATION_NAME = APPLICATION_NAME_JA;
                break;
            }
            case EN: {
                APPLICATION_NAME = APPLICATION_NAME_EN;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TLangType {
        JA,
        EN;

    }
}

