/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import java.awt.event.KeyEvent;
import tuttt.TChapter;
import tuttt.TInterpreter;
import tuttt.TMenu;
import tuttt.TMenuView;
import tuttt.TNIException;
import tuttt.TNKeyInputHandler;
import tuttt.TTApplication;
import tuttt.TTokenizer;

public class TTMenuInterpreter
extends TInterpreter {
    private TMenu _menuModel = new TMenu();
    private TMenuView _menuView;

    public TTMenuInterpreter(TTApplication tTApplication, TTokenizer tTokenizer) {
        super(tTApplication, tTokenizer);
        this._menuView = new TMenuView(this._menuModel, tTApplication.getWindow());
    }

    public boolean start() {
        KeyEvent keyEvent = this._application.getWindow().getInput();
        if (keyEvent == TNKeyInputHandler.TERMINATE_SIGNAL) {
            this._running = false;
            return false;
        }
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this._menuView.up();
                break;
            }
            case 40: {
                this._menuView.down();
                break;
            }
            case 37: {
                this._menuView.left();
                break;
            }
            case 39: {
                this._menuView.right();
                break;
            }
            case 10: 
            case 32: {
                if (!this.runChapter()) {
                    return false;
                }
                this._menuView.redraw();
            }
        }
        return true;
    }

    public void processCommand() {
        this._tokenizer.next();
        while (!this._tokenizer.tokenIs("!MENU_END")) {
            if (this._tokenizer.tokenIs("!MESSAGE")) {
                this.message();
                continue;
            }
            if (this._tokenizer.tokenIs("!TITLE")) {
                this.title();
                continue;
            }
            if (this._tokenizer.tokenIs("!LOAD")) {
                this.load();
                continue;
            }
            if (this._tokenizer.tokenIs("!ITEM")) {
                this.item();
                continue;
            }
            if (this._tokenizer.tokenIs("!EXIT")) {
                this.menuExit();
                continue;
            }
            super.processCommand();
        }
        this._menuView.reset();
        while (this.start()) {
        }
    }

    public boolean runChapter() {
        int n = this._menuView.getCursorX();
        int n2 = this._menuView.getCursorY();
        TChapter tChapter = this._menuModel.getChapter(n2);
        if (tChapter.isExit()) {
            return false;
        }
        String string = tChapter.getFileName();
        TInterpreter tInterpreter = new TInterpreter(this._application, string);
        tInterpreter.run(n2 - 1, n + 1);
        if (!tInterpreter.isEnd()) {
            int n3 = tInterpreter._sectionNo;
            this._menuView.setCursorX(n3 - 1);
        } else {
            if (n2 >= this._menuModel.getChapterSize() - 1) {
                this._menuView.setCursorY(0);
            } else {
                this._menuView.setCursorY(this._menuView.getCursorY() + 1);
            }
            this._menuView.setCursorX(0);
        }
        return true;
    }

    private void message() {
        this._tokenizer.next();
        while (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.STRING)) {
            this._menuModel.addMessage(this._tokenizer.getToken());
            this._tokenizer.next();
        }
    }

    private void title() {
        this._tokenizer.next();
        if (!this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.STRING)) {
            throw new TNIException("!TITLE \u30b3\u30de\u30f3\u30c9\u306e\u4f7f\u7528\u6cd5\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059\u3002" + this.dump());
        }
        TChapter tChapter = new TChapter(this._tokenizer.getToken());
        this._menuModel.addChapter(tChapter);
        this._tokenizer.next();
    }

    private void load() {
        this._tokenizer.next();
        if (!this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.STRING)) {
            throw new TNIException("!LOAD \u30b3\u30de\u30f3\u30c9\u306e\u4f7f\u7528\u6cd5\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059\u3002" + this.dump());
        }
        this._menuModel.getLastChapter().setFileName(this._tokenizer.getToken());
        this._tokenizer.next();
    }

    private void item() {
        this._tokenizer.next();
        while (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.STRING)) {
            this._menuModel.getLastChapter().addSection(this._tokenizer.getToken());
            this._tokenizer.next();
        }
        if (!this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.COMMAND)) {
            this._tokenizer.next();
        }
    }

    private void menuExit() {
        this.item();
        this._menuModel.getLastChapter().setExit();
    }
}

