/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import tuttt.TTestSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTest {
    private List<String> _messages = new ArrayList<String>();
    private List<String> _text = new ArrayList<String>();
    private int _lesson;
    private int _section;
    private int temp = -999;
    private TTestSession _currentSession;
    private Stack<TTestSession> _sessionHistory = new Stack();

    public TTest(int n, int n2) {
        this._lesson = n;
        this._section = n2;
    }

    public void addMessage(String string) {
        this._messages.add(string);
    }

    public String getMessage(int n) {
        return this._messages.get(n);
    }

    public void addText(String string) {
        this._text.add(string);
    }

    public String getText(int n) {
        return this._text.get(n % this._text.size());
    }

    public String getTyped(int n) {
        return this._currentSession.getTyped(n);
    }

    public int getTimes() {
        return this._currentSession.getTimes();
    }

    public void addKeyEvent(KeyEvent keyEvent) {
        this._currentSession.addKeyEvent(keyEvent);
    }

    public void setTimeLimit(int n) {
        this._currentSession.setTimeLimit(n);
    }

    public void setUpSession(int n, int n2) {
        this._currentSession = new TTestSession();
        this._currentSession.setText(this._text);
        this._currentSession.setTimeLimit(n);
        this._currentSession.setTimes(n2);
        this._currentSession.setLesson(this._lesson);
        this._currentSession.setSection(this._section);
    }

    public void start() {
        this._currentSession.start();
    }

    public void endSession() {
        this._currentSession.end();
        this._sessionHistory.push(this._currentSession);
    }

    public boolean isTimeUp() {
        return this._currentSession.isTimeUp();
    }

    public String getErrorCheckText(int n) {
        return this._currentSession.check(n, this.getText(n));
    }

    public List<TTestSession.TWordError> getErrorWordList(int n, int n2) {
        return this._currentSession.getErrorWordList(n, n2);
    }

    public List<TTestSession.TKeyElement> getKeyErrorList() {
        return this._currentSession.getKeyErrorList();
    }

    public int getTotalCount() {
        return this._currentSession.getTotalCount();
    }

    public int getScore(int n) {
        return this._currentSession.getScore(n);
    }

    public int getCorrectRate() {
        return this._currentSession.getCorrectRate();
    }

    public int getCorrectCount() {
        return this._currentSession.getCorrectCount();
    }

    public TTestSession getCurrentSession() {
        return this._currentSession;
    }

    public int getPreferredSpeed() {
        if (this.temp != -999) {
            this._currentSession.setGuideSpeed(this.temp);
            return this.temp;
        }
        if (!this._sessionHistory.isEmpty()) {
            TTestSession tTestSession = this._sessionHistory.peek();
            int n = tTestSession.getIntervalAverage();
            System.out.println("intervalAverage:" + n);
            n = (int)(1.5 * (double)n);
            System.out.println("intervalAverageFixed:" + n);
            int n2 = (int)(60000.0 / (double)n);
            System.out.println("speed:" + n2);
            this._currentSession.setGuideSpeed(n2);
            this.temp = n2;
            return n2;
        }
        return 0;
    }
}

