/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import java.awt.event.KeyEvent;
import java.util.List;
import tuttt.TGlobal;
import tuttt.TInterpreter;
import tuttt.TJHTTPSender;
import tuttt.TNIException;
import tuttt.TNKeyInputHandler;
import tuttt.TTApplication;
import tuttt.TTest;
import tuttt.TTestSession;
import tuttt.TTokenizer;

public class TTestInterpreter
extends TInterpreter {
    private static final int MAX_REPEAT = 10;
    private static final int MAX_TEXT_LINE = 10;
    private static final int MAX_TYPE_LINE = 50;
    private static final int MAX_TYPE = 70;
    private static final int TEST_TIME = TGlobal.getInt("test_time");
    private static final int HAND_X = TGlobal.getInt("hand_x");
    private static final int HAND_Y = TGlobal.getInt("hand_y");
    private static final int SCROLL_LINE = TGlobal.getInt("scroll_line");
    private static final int TEST_X = TGlobal.getInt("test_x");
    private static final int TEST_Y = TGlobal.getInt("test_y");
    private static final int TEST_WIDTH = TGlobal.getInt("test_width");
    private static final int TEST_HEIGHT = TGlobal.getInt("scroll_line") * 2 - 1;
    private static final int TEST_HAND_X = TGlobal.getInt("test_hand_x");
    private static final int TEST_HAND_Y = TGlobal.getInt("test_hand_y");
    private static final int ERR_MESS_X = TGlobal.getInt("disp_x") + 13;
    private static final int ERR_MESS_Y = TGlobal.getInt("disp_y");
    private static final int ERR_DISP_X = TGlobal.getInt("disp_x") + 8;
    private static final int ERR_DISP_Y = TGlobal.getInt("disp_y") + 4;
    private static final int RESULT_X = ERR_MESS_X;
    private static final int RESULT_Y = ERR_MESS_Y;
    private TTest _test;
    private int x;
    private int y;

    public TTestInterpreter(TTApplication tTApplication, TTokenizer tTokenizer, int n, int n2) {
        super(tTApplication, tTokenizer);
        this._test = new TTest(n, n2);
        this._lessonNo = n;
        this._sectionNo = n2;
    }

    public boolean processCommandTest() {
        this._running = true;
        this.goto_next();
        while (!this._tokenizer.tokenIs("!TEST_END")) {
            if (this._tokenizer.tokenIs("!TEXT")) {
                this.text();
                continue;
            }
            if (this._tokenizer.tokenIs("!MESSAGE")) {
                this.message();
                continue;
            }
            this.processCommand();
        }
        for (int i = 1; i <= TGlobal.getInt("repeat"); ++i) {
            this.mainloop(i);
            if (this._running) continue;
            return false;
        }
        return true;
    }

    private void text() {
        this._tokenizer.next();
        int n = 0;
        while (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.STRING)) {
            if (n >= 10) {
                throw new TNIException("\u7df4\u7fd2\u30c6\u30ad\u30b9\u30c8\u304c\u591a\u3059\u304e\u307e\u3059\u3002" + this.dump());
            }
            this._test.addText(this._tokenizer.getToken());
            this._tokenizer.next();
            ++n;
        }
    }

    private void message() {
        this._tokenizer.next();
        int n = 0;
        while (this._tokenizer.tokenTypeIs(TTokenizer.TTokenType.STRING)) {
            if (n >= 10) {
                throw new TNIException("\u30c6\u30b9\u30c8\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u591a\u3059\u304e\u307e\u3059\u3002" + this.dump());
            }
            this._test.addMessage(this._tokenizer.getToken());
            this._tokenizer.next();
            ++n;
        }
    }

    private void mainloop(int n) {
        this._test.setUpSession(TEST_TIME, n);
        this.prepare();
        if (!this._running) {
            return;
        }
        this.typing(n);
        if (!this._running) {
            return;
        }
        this.error_check();
        if (!this._running) {
            return;
        }
        this.word_exercise();
        if (!this._running) {
            return;
        }
        this.result();
    }

    private void prepare() {
        this._application.getWindow().clear();
        this._application.getWindow().moveTo(HAND_X + 17, HAND_Y - 3);
        this._application.getWindow().drawRevString(TGlobal.getString("reverse_message"));
        this._application.getWindow().drawString(TGlobal.getString("newkey_message"));
        this._application.getWindow().moveTo(HAND_X + 39, HAND_Y - 3);
        this._application.getWindow().drawString(TGlobal.getString("normal_message"));
        this._application.getWindow().drawString(TGlobal.getString("learnedkey_message"));
        this.displayHand(HAND_X, HAND_Y);
        this.displayTestLabel(HAND_X + 12, HAND_Y - 6);
        this.displayGuide();
        this.pause(TGlobal.getString("test_pause_message"), false);
    }

    private void typing(int n) {
        int n2 = TGlobal.getInt("cursor");
        boolean bl = n == 1 ? false : false;
        boolean bl2 = true;
        int n3 = this._test.getPreferredSpeed();
        this._application.getWindow().clear();
        this.x = 0;
        this.y = 0;
        if (TGlobal.getInt("hand") != 0) {
            this.displayHand(TEST_HAND_X, TEST_HAND_Y);
        }
        this.displayTestLabel(TEST_HAND_X + 12, TEST_HAND_Y - 2);
        this.displayGuide();
        this.disp_text();
        this._application.getWindow().moveCursorToCurrentPostion();
        if (bl) {
            this._application.getWindow().moveSpeedGuideToCurrentPostion();
            this._application.getWindow().drawGuideSpeedLabel(n3);
        }
        this._test.start();
        block4: while (true) {
            KeyEvent keyEvent;
            if ((keyEvent = this._application.getWindow().getInput()) == TNKeyInputHandler.TERMINATE_SIGNAL) {
                this._running = false;
                return;
            }
            char c = keyEvent.getKeyChar();
            if (this._test.isTimeUp()) {
                this._test.endSession();
                this._application.getWindow().hideSpeedGuide();
                this._application.getWindow().stopSpeedGuide();
                return;
            }
            switch (c) {
                case '\u001b': {
                    if (bl) {
                        this._application.getWindow().hideSpeedGuide();
                        this._application.getWindow().stopSpeedGuide();
                    }
                    this._running = false;
                    return;
                }
                case '\n': {
                    if (this.y < 49) {
                        this._test.addKeyEvent(keyEvent);
                        this.x = 0;
                        ++this.y;
                        this._application.getWindow().hideCursor();
                        if (bl) {
                            this._application.getWindow().hideSpeedGuide();
                        }
                        this.disp_text();
                        this._application.getWindow().moveCursorToCurrentPostion();
                        if (bl) {
                            this._application.getWindow().stopSpeedGuide();
                            this._application.getWindow().moveSpeedGuideToCurrentPostion();
                        }
                        bl2 = true;
                        continue block4;
                    }
                    this._test.endSession();
                    if (bl) {
                        this._application.getWindow().hideSpeedGuide();
                        this._application.getWindow().stopSpeedGuide();
                    }
                    return;
                }
            }
            if (this.x < 70 && c >= ' ' && c < '\u007f') {
                if (bl && bl2) {
                    if (n3 != 0) {
                        String string = this._test.getText(this.y);
                        this._application.getWindow().startSpeedGuide(n3, string.length());
                    }
                    bl2 = false;
                }
                this._test.addKeyEvent(keyEvent);
                ++this.x;
                if (n2 == 0) continue;
                this._application.getWindow().forwardCursor(1);
                this._application.getWindow().forwadX(1);
                continue;
            }
            if (this.x <= 70) continue;
            this._test.endSession();
            if (!bl) continue;
            this._application.getWindow().hideSpeedGuide();
            this._application.getWindow().stopSpeedGuide();
        }
    }

    private void error_check() {
        this.showErrorCheckInstraction();
        int n = 0;
        while (n <= this.y) {
            this._application.getWindow().clear();
            this.displayTestLabel(ERR_MESS_X + 2, ERR_MESS_Y);
            this._application.getWindow().moveTo(ERR_MESS_X, ERR_MESS_Y + 2);
            this._application.getWindow().drawRevString(TGlobal.getString("errchk_message"));
            this.displayGuide();
            for (int i = 0; i < SCROLL_LINE && n <= this.y; ++i, ++n) {
                this._application.getWindow().moveTo(ERR_DISP_X, ERR_DISP_Y + i * 4);
                this._application.getWindow().drawString(this._test.getText(n));
                this._application.getWindow().moveTo(ERR_DISP_X, ERR_DISP_Y + i * 4 + 1);
                this._application.getWindow().drawString(this._test.getTyped(n));
                this._application.getWindow().moveTo(ERR_DISP_X, ERR_DISP_Y + i * 4 + 2);
                String string = this._test.getErrorCheckText(n);
                this._application.getWindow().drawString(string);
            }
            this.longPause(TGlobal.getString("long_pause_message_test"), false);
            if (this._running) continue;
            return;
        }
    }

    private void showErrorCheckInstraction() {
        this._application.getWindow().clear();
        this.displayGuide();
        this._application.getWindow().moveTo(0, 6);
        this._application.getWindow().drawCenterString(TGlobal.getString("review_message1"));
        this._application.getWindow().moveTo(0, 10);
        this._application.getWindow().drawCenterString(TGlobal.getString("review_message2"));
        this._application.getWindow().moveTo(0, 12);
        this._application.getWindow().drawCenterString(TGlobal.getString("review_message3"));
        this.pause(TGlobal.getString("long_pause_message_review"), false);
    }

    private void word_exercise() {
        int n;
        List<TTestSession.TWordError> list = this._test.getErrorWordList(4, 1);
        if (list.size() == 0) {
            return;
        }
        this._application.getWindow().clear();
        this._application.getWindow().moveTo(0, 6);
        this._application.getWindow().drawCenterString(TGlobal.getString("review_title"));
        this._application.getWindow().moveTo(0, 10);
        this._application.getWindow().drawCenterString(TGlobal.getString("miss_lank1") + list.size() + TGlobal.getString("miss_lank2"));
        this._application.getWindow().moveTo(0, 12);
        for (n = 0; n < list.size(); ++n) {
            this._application.getWindow().moveXTo(22);
            this._application.getWindow().drawString("\u30fb " + list.get((int)n).contents);
            this._application.getWindow().drawString("\u2026" + list.get((int)n).totalCount + TGlobal.getString("miss_lank3") + list.get((int)n).errorCount + TGlobal.getString("miss_lank4"));
            this._application.getWindow().forwadY(1);
        }
        this.pause(TGlobal.getString("long_pause_message_review2"), false);
        this._application.getWindow().clear();
        this.x = 0;
        this.y = 0;
        if (TGlobal.getInt("hand") != 0) {
            this.displayHand(TEST_HAND_X, TEST_HAND_Y);
        }
        this.displayTestLabel(TEST_HAND_X + 12, TEST_HAND_Y - 2);
        n = this.disp_words(list.get(this.y));
        this._application.getWindow().moveCursorToCurrentPostion();
        block4: while (true) {
            KeyEvent keyEvent;
            if ((keyEvent = this._application.getWindow().getInput()) == TNKeyInputHandler.TERMINATE_SIGNAL) {
                this._running = false;
                return;
            }
            char c = keyEvent.getKeyChar();
            switch (c) {
                case '\n': {
                    continue block4;
                }
            }
            if (this.x >= 70 || c < ' ' || c >= '\u007f') continue;
            ++this.x;
            if (n - 1 < this.x) {
                this.x = 0;
                ++this.y;
                if (this.y > list.size() - 1) {
                    return;
                }
                n = this.disp_words(list.get(this.y));
                this._application.getWindow().hideCursor();
                this._application.getWindow().moveCursorToCurrentPostion();
                continue;
            }
            this._application.getWindow().forwardCursor(1);
            this._application.getWindow().drawString(String.valueOf(c));
        }
    }

    private int disp_words(TTestSession.TWordError tWordError) {
        int n = 17;
        this._application.getWindow().clearLine(n);
        this._application.getWindow().clearLine(n + 1);
        this._application.getWindow().clearLine(n + 2);
        this._application.getWindow().moveTo(TEST_X, n);
        String string = tWordError.contents;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((double)TEST_WIDTH * 0.4 > (double)stringBuilder.length()) {
            stringBuilder.append(" ");
            stringBuilder.append(string);
        }
        this._application.getWindow().drawString(TGlobal.getString("review_try_pre") + string + TGlobal.getString("review_try_post"));
        this._application.getWindow().moveTo(TEST_X, n + 1);
        this._application.getWindow().drawString(stringBuilder.toString());
        this._application.getWindow().moveYTo(23);
        this._application.getWindow().drawRevCenterString(TGlobal.getString("review_next"));
        if (TGlobal.getInt("cursor") != 0) {
            this._application.getWindow().moveTo(TEST_X, n + 2);
        } else {
            this._application.getWindow().moveTo(0, 0);
        }
        return stringBuilder.length();
    }

    private void result() {
        this._application.getWindow().clear();
        this.displayTestLabel(RESULT_X + 2, RESULT_Y);
        this._application.getWindow().moveTo(RESULT_X, RESULT_Y + 2);
        this._application.getWindow().drawRevString(TGlobal.getString("result_message"));
        this._application.getWindow().moveTo(RESULT_X + 5, RESULT_Y + 5);
        this._application.getWindow().drawString(TGlobal.getString("total_type"));
        this._application.getWindow().drawString(Integer.toString(this._test.getTotalCount()));
        this._application.getWindow().drawString(" ");
        this._application.getWindow().drawString(TGlobal.getString("word_message"));
        this._application.getWindow().moveTo(RESULT_X + 5, RESULT_Y + 7);
        this._application.getWindow().drawString(TGlobal.getString("correct_type"));
        this._application.getWindow().drawString(Integer.toString(this._test.getCorrectCount()));
        this._application.getWindow().drawString(" ");
        this._application.getWindow().drawString(TGlobal.getString("word_message"));
        this._application.getWindow().moveTo(RESULT_X + 5, RESULT_Y + 9);
        this._application.getWindow().drawString(TGlobal.getString("correct_rate"));
        this._application.getWindow().drawString(Integer.toString(this._test.getCorrectRate()));
        this._application.getWindow().drawString(" ");
        this._application.getWindow().drawString(TGlobal.getString("percent_message"));
        this._application.getWindow().moveTo(RESULT_X + 5, RESULT_Y + 11);
        this._application.getWindow().drawString(TGlobal.getString("score_message"));
        this._application.getWindow().drawString(Integer.toString(this._test.getScore(TGlobal.getInt("penalty"))));
        this._application.getWindow().drawString(" ");
        this._application.getWindow().drawString(TGlobal.getString("word_message"));
        this._application.getWindow().moveTo(RESULT_X, RESULT_Y + 13);
        this._application.getWindow().drawCenterString(this._test.getMessage(this._test.getTimes() - 1));
        this.displayGuide();
        TTestSession tTestSession = this._test.getCurrentSession();
        if (this._application.isAppletMode() && tTestSession.getTotalCount() != 0) {
            TJHTTPSender tJHTTPSender = new TJHTTPSender(this._application, this._application.getWindow());
            tJHTTPSender.send(tTestSession);
        }
        this.pause(TGlobal.getString("pause_message_test"), false);
    }

    private void disp_text() {
        int n;
        if (this.y < SCROLL_LINE) {
            n = TEST_Y + this.y * 2;
        } else {
            n = TEST_Y + SCROLL_LINE * 2 - 2;
            this._application.getWindow().scrollUp(TEST_X, TEST_Y, TEST_WIDTH, TEST_HEIGHT);
            this._application.getWindow().scrollUp(TEST_X, TEST_Y, TEST_WIDTH, TEST_HEIGHT);
        }
        this._application.getWindow().moveTo(TEST_X, n);
        this._application.getWindow().drawString(this._test.getText(this.y));
        if (TGlobal.getInt("cursor") != 0) {
            this._application.getWindow().moveTo(TEST_X, n + 1);
        } else {
            this._application.getWindow().moveTo(0, 0);
        }
    }

    private void displayTestLabel(int n, int n2) {
        this._application.getWindow().moveTo(n, n2);
        StringBuilder stringBuilder = new StringBuilder("\u300a");
        stringBuilder.append(TGlobal.getString("lesson_message"));
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this._lessonNo));
        stringBuilder.append("  ");
        stringBuilder.append(TGlobal.getString("section_message"));
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this._sectionNo));
        stringBuilder.append("\u300b");
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this._test.getTimes()));
        stringBuilder.append(" ");
        stringBuilder.append(TGlobal.getString("times_message"));
        this._application.getWindow().drawString(stringBuilder.toString());
    }
}

