/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import tuttt.TKeyEventLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTestSession {
    private List<String> _text;
    private List<String> _typed = new ArrayList<String>();
    private List<String> _error = new ArrayList<String>();
    private List<TKeyEventLog> _logs = new ArrayList<TKeyEventLog>();
    private StringBuilder _typedBuffer = new StringBuilder();
    private Map<String, TWordError> _wordTable = new HashMap<String, TWordError>();
    private Map<String, TKeyElement> _keyTable = new HashMap<String, TKeyElement>();
    private long _startTime;
    private int _timeLimit;
    private int _lesson;
    private int _section;
    private int _times;
    private int _totalCount;
    private int _errorCount;
    private int _guideSpeed = -1;
    private int i;
    private int j;
    private StringBuilder err_buf;

    public void setGuideSpeed(int n) {
        this._guideSpeed = n;
    }

    public int getGuideSpeed() {
        return this._guideSpeed;
    }

    public void start() {
        this._startTime = System.currentTimeMillis();
        System.out.println(this._startTime);
    }

    public void setText(List<String> list) {
        this._text = list;
    }

    public String getText(int n) {
        return this._text.get(n % this._text.size());
    }

    public String getTyped(int n) {
        return this._typed.get(n);
    }

    public int getTypedSize() {
        return this._typed.size();
    }

    public void setTimeLimit(int n) {
        this._timeLimit = n;
        System.out.println(n);
    }

    public boolean isTimeUp() {
        long l = System.currentTimeMillis();
        if (l - this._startTime >= (long)(this._timeLimit * 1000)) {
            System.out.println(l);
            System.out.println(this._timeLimit * 1000);
            return true;
        }
        return false;
    }

    public void setLesson(int n) {
        this._lesson = n;
    }

    public int getLesson() {
        return this._lesson;
    }

    public void setSection(int n) {
        this._section = n;
    }

    public int getSection() {
        return this._section;
    }

    public void setTimes(int n) {
        this._times = n;
    }

    public int getTimes() {
        return this._times;
    }

    public void addKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this._typed.add(this._typedBuffer.toString());
                this.recordKeyEventLog(keyEvent);
                this._typedBuffer = new StringBuilder();
                break;
            }
            default: {
                this._typedBuffer.append(keyEvent.getKeyChar());
                this.recordKeyEventLog(keyEvent);
            }
        }
    }

    public void end() {
        this._typed.add(this._typedBuffer.toString());
        this._typedBuffer = new StringBuilder();
    }

    private void recordKeyEventLog(KeyEvent keyEvent) {
        TKeyEventLog tKeyEventLog;
        long l = System.currentTimeMillis() - this._startTime;
        TKeyEventLog tKeyEventLog2 = this._logs.size() > 0 ? (!(tKeyEventLog = this._logs.get(this._logs.size() - 1)).isEnterKeyPressed() ? new TKeyEventLog(keyEvent, l, tKeyEventLog.getTime()) : new TKeyEventLog(keyEvent, l, 0L)) : new TKeyEventLog(keyEvent, l, 0L);
        this._logs.add(tKeyEventLog2);
    }

    public List<TKeyEventLog> getLog() {
        return this._logs;
    }

    private void addErrorCount(int n) {
        this._errorCount += n;
    }

    private void addTotalCount(int n) {
        this._totalCount += n;
    }

    public int getTotalCount() {
        return this._totalCount;
    }

    public int error_type() {
        return this._errorCount;
    }

    public int getCorrectCount() {
        return this._totalCount - this._errorCount;
    }

    public int getCorrectRate() {
        if (this._totalCount > 0) {
            return this.getCorrectCount() * 100 / this._totalCount;
        }
        return 0;
    }

    public int getScore(int n) {
        return this._totalCount - this._errorCount * n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u30ec\u30c3\u30b9\u30f3" + this._lesson);
        stringBuilder.append("\u30bb\u30af\u30b7\u30e7\u30f3" + this._section);
        stringBuilder.append("\u56de\u76ee" + this._times);
        for (int i = 0; i < this._text.size(); ++i) {
            stringBuilder.append(this._text.get(i));
            stringBuilder.append(this._typed.get(i));
            stringBuilder.append(this._error.get(i));
        }
        return stringBuilder.toString();
    }

    public List<String> getError() {
        return this._error;
    }

    public String check(int n, String string) {
        this.err_buf = new StringBuilder();
        String string2 = this.getTyped(n);
        this.j = 0;
        this.i = 0;
        if (string2 == null) {
            return "";
        }
        int n2 = string.length();
        int n3 = string2.length();
        while (this.j < n3) {
            char c;
            if (this.i >= n2) {
                this.check_sub("E", 1);
                continue;
            }
            char c2 = string.charAt(this.i);
            if (c2 != (c = string2.charAt(this.j))) {
                if (this.i + 1 < n2 && this.j + 1 < n3) {
                    char c3 = string.charAt(this.i + 1);
                    char c4 = string2.charAt(this.j + 1);
                    if (c2 == c4 && c3 == c) {
                        this.check_sub("XX", 2);
                        continue;
                    }
                    if (c3 == c4 && c3 != c) {
                        this.check_sub("E ", 2);
                        continue;
                    }
                    if (c2 == c4 && c3 != c) {
                        this.check_sub("I ", 1);
                        continue;
                    }
                    if (c3 == c) {
                        this.check_sub("D", 2, 0);
                        continue;
                    }
                    if (this.i + 2 < n2 && this.j + 2 < n3) {
                        char c5;
                        char c6 = string.charAt(this.i + 2);
                        if (c6 == (c5 = string2.charAt(this.j + 2))) {
                            this.check_sub("EE ", 3);
                            continue;
                        }
                        if (c3 == c5) {
                            this.check_sub("EE ", 2);
                            continue;
                        }
                        if (c6 == c4) {
                            this.check_sub("E ", 3);
                            continue;
                        }
                        if (c2 == c5) {
                            this.check_sub("EE ", 1);
                            continue;
                        }
                        if (c6 == c) {
                            this.check_sub("D ", 3, 0);
                            continue;
                        }
                        if (this.i + 3 < n2 && this.j + 3 < n3) {
                            char c7;
                            char c8 = string.charAt(this.i + 3);
                            if (c8 == (c7 = string2.charAt(this.j + 3))) {
                                this.check_sub("EEE ", 4);
                                continue;
                            }
                            this.check_sub("E", 1);
                            continue;
                        }
                        this.check_sub("E", 1);
                        continue;
                    }
                    this.check_sub("E", 1);
                    continue;
                }
                this.check_sub("E", 1);
                continue;
            }
            this.check_sub(" ", 1);
        }
        String string3 = this.err_buf.toString();
        this._error.add(string3);
        this.detectWordError(n, string);
        this.detectKeyError(n, string);
        return string3;
    }

    private void check_sub(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            ++n2;
        }
        this.check_sub(string, n, n2);
    }

    private void check_sub(String string, int n, int n2) {
        this.err_buf.append(string);
        this.j += string.length();
        this.i += n;
        this.addTotalCount(n);
        this.addErrorCount(n2);
    }

    private void detectWordError(int n, String string) {
        int n2;
        Object object;
        if (this.getTyped(n).length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<char[]> arrayList = new ArrayList<char[]>();
        while (stringTokenizer.hasMoreTokens()) {
            object = new TWordElement();
            ((TWordElement)object).contents = stringTokenizer.nextToken();
            arrayList.add((char[])object);
        }
        object = string.toCharArray();
        char[] cArray = this._error.get(n).toCharArray();
        int n3 = -1;
        for (n2 = 0; n2 < ((char[])object).length && n2 <= cArray.length && n2 <= ((char[])object).length; ++n2) {
            while (object[n2] == ' ') {
                ++n2;
            }
            ++n3;
            while (n2 < ((char[])object).length && n2 < cArray.length && object[n2] != ' ') {
                if (cArray[n2] != ' ') {
                    ((TWordElement)arrayList.get(n3)).hasErorr = true;
                }
                ++n2;
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            TWordError tWordError;
            TWordElement tWordElement = (TWordElement)arrayList.get(n2);
            if (!this._wordTable.containsKey(tWordElement.contents)) {
                tWordError = new TWordError();
                tWordError.contents = tWordElement.contents;
                ++tWordError.totalCount;
                if (tWordElement.hasErorr) {
                    ++tWordError.errorCount;
                }
                this._wordTable.put(tWordElement.contents, tWordError);
                continue;
            }
            tWordError = this._wordTable.get(tWordElement.contents);
            ++tWordError.totalCount;
            if (!tWordElement.hasErorr) continue;
            ++tWordError.errorCount;
        }
    }

    public List<TWordError> getErrorWordList(int n, int n2) {
        Collection<TWordError> collection = this._wordTable.values();
        ArrayList<TWordError> arrayList = new ArrayList<TWordError>(collection);
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            TWordError tWordError = (TWordError)arrayList.get(i);
            if (tWordError.errorCount > n2) continue;
            arrayList.remove(i);
            --i;
        }
        if (arrayList.size() == 0) {
            return arrayList;
        }
        if (arrayList.size() >= n) {
            return arrayList.subList(0, n);
        }
        return arrayList.subList(0, arrayList.size());
    }

    private void detectKeyError(int n, String string) {
        if (this.getTyped(n).length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = this._error.get(n).toCharArray();
        block6: for (int i = 0; i < cArray.length && i <= cArray2.length - 1 && i <= cArray.length - 1; ++i) {
            TKeyElement tKeyElement;
            char c = cArray[i];
            char c2 = cArray2[i];
            if (this._keyTable.containsKey(String.valueOf(c))) {
                tKeyElement = this._keyTable.get(String.valueOf(c));
            } else {
                tKeyElement = new TKeyElement();
                tKeyElement.key = String.valueOf(c);
                this._keyTable.put(tKeyElement.key, tKeyElement);
            }
            tKeyElement.total++;
            switch (c2) {
                case 'X': {
                    tKeyElement.x++;
                    continue block6;
                }
                case 'I': {
                    tKeyElement.i++;
                    continue block6;
                }
                case 'D': {
                    tKeyElement.d++;
                    continue block6;
                }
                case 'E': {
                    tKeyElement.e++;
                    continue block6;
                }
            }
        }
    }

    public List<TKeyElement> getKeyErrorList() {
        ArrayList<TKeyElement> arrayList = new ArrayList<TKeyElement>(this._keyTable.values());
        return arrayList;
    }

    public int getIntervalAverage() {
        int n = 0;
        long l = 0L;
        for (int i = 0; i < this._logs.size(); ++i) {
            if (this._logs.get(i).getInterval() == 0L) continue;
            l += this._logs.get(i).getInterval();
            ++n;
        }
        if (n != 0) {
            return (int)(l / (long)n);
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TWordError
    implements Comparable<TWordError> {
        public String contents;
        public int totalCount;
        public int errorCount;

        public String toString() {
            return this.contents + "(" + this.errorCount + "/" + this.totalCount + ")";
        }

        @Override
        public int compareTo(TWordError tWordError) {
            if (this.errorCount == tWordError.errorCount) {
                return tWordError.contents.length() - this.contents.length();
            }
            return tWordError.errorCount - this.errorCount;
        }
    }

    private class TWordElement {
        private String contents;
        private boolean hasErorr = false;

        private TWordElement() {
        }
    }

    public class TKeyElement {
        private String key;
        private int x;
        private int i;
        private int d;
        private int e;
        private int total;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.key);
            stringBuilder.append("\t");
            stringBuilder.append("X:");
            stringBuilder.append("\t");
            stringBuilder.append(this.x);
            stringBuilder.append("\t");
            stringBuilder.append("I:");
            stringBuilder.append("\t");
            stringBuilder.append(this.i);
            stringBuilder.append("\t");
            stringBuilder.append("D:");
            stringBuilder.append("\t");
            stringBuilder.append(this.d);
            stringBuilder.append("\t");
            stringBuilder.append("E:");
            stringBuilder.append("\t");
            stringBuilder.append(this.e);
            stringBuilder.append("\t");
            stringBuilder.append("ErrorTotal:");
            stringBuilder.append("\t");
            stringBuilder.append(this.x + this.i + this.d + this.e);
            stringBuilder.append("\t");
            stringBuilder.append("Total:");
            stringBuilder.append("\t");
            stringBuilder.append(this.total);
            return stringBuilder.toString();
        }
    }
}

