/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Stack;
import tuttt.TNIException;

public class TTokenizer {
    private static final String FILE_ENCORDING = "MS932";
    private String _fileName;
    private boolean _bootApplet;
    private StreamTokenizer _tokenizer;
    private String _token;
    private TTokenType _tokenType = TTokenType.UNDEF;
    private Stack<TRollBackPoint> _history = new Stack();

    public TTokenizer(String string, boolean bl) {
        this._fileName = string;
        this._bootApplet = bl;
        this._tokenizer = this.createTokenizer(this.createReader(string, bl));
    }

    private Reader createReader(String string, boolean bl) {
        URL uRL = this.getClass().getClassLoader().getResource(string);
        if (bl) {
            return this.createReaderFromURL(uRL);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, FILE_ENCORDING);
            return new BufferedReader(inputStreamReader);
        }
        catch (Exception exception) {
            return this.createReaderFromURL(uRL);
        }
    }

    private Reader createReaderFromURL(URL uRL) {
        if (uRL == null) {
            throw new TNIException(this._fileName + " \u8aad\u307f\u53d6\u308a\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
        try {
            InputStream inputStream = uRL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, FILE_ENCORDING);
            return new BufferedReader(inputStreamReader);
        }
        catch (Exception exception) {
            throw new TNIException(this._fileName + " \u8aad\u307f\u53d6\u308a\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }

    private StreamTokenizer createTokenizer(Reader reader) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(33, 33);
        streamTokenizer.commentChar(35);
        return streamTokenizer;
    }

    public void next() {
        try {
            block1 : switch (this._tokenizer.nextToken()) {
                case -1: {
                    this._tokenType = TTokenType.END;
                    this._token = this._tokenizer.sval;
                    break;
                }
                case -2: {
                    this._tokenType = TTokenType.NUMBER;
                    this._token = String.valueOf((int)this._tokenizer.nval);
                    break;
                }
                case -3: {
                    switch (this._tokenizer.sval.charAt(0)) {
                        case '!': {
                            this._tokenType = TTokenType.COMMAND;
                            this._token = this._tokenizer.sval;
                            break block1;
                        }
                    }
                    this._tokenType = TTokenType.SYMBOL;
                    this._token = this._tokenizer.sval;
                    break;
                }
                case 34: {
                    this._tokenType = TTokenType.STRING;
                    this._token = this._tokenizer.sval;
                    break;
                }
                default: {
                    this._tokenType = TTokenType.UNDEF;
                    this._token = null;
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw new TNIException(this._fileName + " \u8aad\u307f\u53d6\u308a\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public String getToken() {
        return this._token;
    }

    public boolean tokenIs(String string) {
        return this._token.equals(string);
    }

    public boolean tokenTypeIs(TTokenType tTokenType) {
        return this._tokenType == tTokenType;
    }

    public void saveRollBackPoint() {
        TRollBackPoint tRollBackPoint = new TRollBackPoint();
        tRollBackPoint.lineNumber = this._tokenizer.lineno();
        tRollBackPoint.fileName = this._fileName;
        this._history.push(tRollBackPoint);
    }

    public boolean doRollBack() {
        if (this._history.size() < 2) {
            return false;
        }
        this._history.pop();
        TRollBackPoint tRollBackPoint = this._history.pop();
        this._fileName = tRollBackPoint.fileName;
        int n = tRollBackPoint.lineNumber;
        this._tokenizer = this.createTokenizer(this.createReader(this._fileName, this._bootApplet));
        try {
            do {
                this._tokenizer.nextToken();
            } while (this._tokenizer.lineno() < n);
            this._tokenizer.pushBack();
            String string = this._tokenizer.sval;
            if (string.equals("!PAUSE_B") || string.equals("!LONG_PAUSE_B")) {
                this._tokenizer.nextToken();
            }
            return true;
        }
        catch (IOException iOException) {
            throw new TNIException(this._fileName + " \u8aad\u307f\u53d6\u308a\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public String dump() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\uff1a");
        stringBuilder.append(this._fileName);
        stringBuilder.append("\uff08");
        stringBuilder.append(this._tokenizer.lineno());
        stringBuilder.append("\u884c\u76ee\uff09");
        return stringBuilder.toString();
    }

    private class TRollBackPoint {
        int lineNumber;
        String fileName;

        private TRollBackPoint() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TTokenType {
        COMMAND,
        NUMBER,
        SYMBOL,
        STRING,
        END,
        UNDEF;

    }
}

