/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JPanel;
import tuttt.TFontManager;
import tuttt.TNKeyInputHandler;
import tuttt.TTApplication;
import tuttt.TWindowBlocker;

public class TWindow
extends JPanel {
    private static final int WIDTH = 80;
    private static final int HEIGHT = 25;
    private static final Font FONT = TFontManager.getDefaultFont();
    private static final Color FOREGROUND_COLOR = Color.BLACK;
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private static final Color ERROR_COLOR = Color.RED;
    private static final String ICON_FILE = "windowicon.gif";
    private static final String ERROR_PREFIX = "\uff3b\u30a8\u30e9\u30fc\uff3d";
    private static int IMAGE_TYPE = 1;
    private FontMetrics _fm;
    private BufferedImage _bufferedImage;
    private Graphics2D _g;
    private int _currentX = 0;
    private int _currentY = 0;
    private int _cursorX = 0;
    private int _cursorY = 0;
    private int _descentCache;
    private int _heightCache;
    private int _charWidthCache;
    private TTApplication _application;
    private JFrame _frame;
    private TWindowBlocker _blocker;
    private TNKeyInputHandler _keyInputHandler;
    Timer timer;
    long guideSpeed;
    int gx;
    int gy;
    long time;
    int _limitX;
    int _speed;

    public TWindow(TTApplication tTApplication) {
        this._application = tTApplication;
        this.initializeFontSizeCache();
        this.setSize(this.getPreferredWindowSize(tTApplication.isAppletMode()));
        this.initializeGraphics();
        this.initializeFrame(tTApplication);
        this.initializeWindowBlocker();
        this.initializeKeyInputHandler();
    }

    private void initializeFontSizeCache() {
        this._fm = this.getFontMetrics(FONT);
        this._descentCache = TFontManager.useTrueTypeFont() ? this._fm.getMaxDescent() + 2 : this._fm.getMaxDescent();
        this._heightCache = this._fm.getHeight();
        this._charWidthCache = this._fm.charWidth('M');
    }

    private Dimension getPreferredWindowSize(boolean bl) {
        Dimension dimension = new Dimension();
        dimension.width = 81 * this._charWidthCache;
        dimension.height = 26 * this._heightCache + this._descentCache;
        if (bl) {
            dimension.height += 27;
        }
        return dimension;
    }

    private void initializeGraphics() {
        this._bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), IMAGE_TYPE);
        this._g = this._bufferedImage.createGraphics();
        this._g.setFont(FONT);
        this._g.setBackground(BACKGROUND_COLOR);
        this._g.setColor(FOREGROUND_COLOR);
        this._g.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (TFontManager.useTrueTypeFont()) {
            this._g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    private void initializeFrame(TTApplication tTApplication) {
        this._frame = new JFrame();
        this._frame.setTitle(this.getWindowTitle());
        this._frame.setSize(this.getWidth(), this.getHeight());
        this._frame.setResizable(false);
        this._frame.setLocationRelativeTo(null);
        URL uRL = this.getClass().getResource(ICON_FILE);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this._frame.setIconImage(toolkit.getImage(uRL));
        this._frame.setDefaultCloseOperation(2);
        this._frame.addWindowListener(new TWindowAdapter());
        this._frame.enableInputMethods(false);
        this._frame.getContentPane().add(this);
    }

    private void initializeWindowBlocker() {
        this._blocker = new TWindowBlocker(this);
        this._frame.setGlassPane(this._blocker);
    }

    private String getWindowTitle() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TTApplication.APPLICATION_NAME);
        stringBuilder.append(" - ");
        stringBuilder.append("1.42");
        stringBuilder.append(" <Build:");
        stringBuilder.append("2013051301");
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    private void initializeKeyInputHandler() {
        this._keyInputHandler = new TNKeyInputHandler(this);
        this._frame.addKeyListener(this._keyInputHandler.createKeyAdapter());
    }

    public void open() {
        if (this._application.isAppletMode() && this._application.getApplet().getMoodleSignedJar().equals("true")) {
            this._frame.setAlwaysOnTop(true);
        }
        this._frame.setVisible(true);
    }

    public void close() {
        this._keyInputHandler.shutdown();
        this._frame.dispose();
    }

    public KeyEvent getInput() {
        return this._keyInputHandler.getInput();
    }

    public void drawString(String string) {
        this.clear(string, BACKGROUND_COLOR);
        this._g.drawString(string, this._currentX, this._currentY - this._descentCache);
        int n = this._currentY - this._heightCache;
        this.repaint(this._currentX, n, this._fm.stringWidth(string), this._heightCache);
        this._currentX += this._fm.stringWidth(string);
    }

    private void drawString(String string, Color color) {
        this.clear(string, BACKGROUND_COLOR);
        this._g.setColor(color);
        this._g.drawString(string, this._currentX, this._currentY - this._descentCache);
        int n = this._currentY - this._heightCache;
        this.repaint(this._currentX, n, this._fm.stringWidth(string), this._heightCache);
        this._currentX += this._fm.stringWidth(string);
    }

    public void drawRevString(String string) {
        this.clear(string, FOREGROUND_COLOR);
        this._g.setColor(BACKGROUND_COLOR);
        this._g.drawString(string, this._currentX, this._currentY - this._descentCache);
        int n = this._currentY - this._heightCache;
        this.repaint(this._currentX, n, this._fm.stringWidth(string), this._heightCache);
        this._currentX += this._fm.stringWidth(string);
        this._g.setColor(FOREGROUND_COLOR);
    }

    public void drawCenterString(String string) {
        this._currentX = this.getCenterStartX(string);
        this.drawString(string);
    }

    public void drawRevCenterString(String string) {
        this._currentX = this.getCenterStartX(string);
        this.drawRevString(string);
    }

    private int getCenterStartX(String string) {
        int n = this._fm.stringWidth(string);
        int n2 = 81 * this._charWidthCache;
        return (n2 - n) / 2;
    }

    public void moveTo(int n, int n2) {
        this.moveXTo(n);
        this.moveYTo(n2);
    }

    public void moveXTo(int n) {
        this._currentX = n * this._charWidthCache;
    }

    public void moveYTo(int n) {
        this._currentY = (n + 1) * this._heightCache;
    }

    public void forwadX(int n) {
        this._currentX += n * this._charWidthCache;
    }

    public void forwadY(int n) {
        this._currentY += n * this._heightCache;
    }

    public void clear() {
        this._g.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.repaint();
    }

    public void moveCursor(int n, int n2) {
        this.hideCursor();
        this._cursorX = n;
        this._cursorY = n2;
        int n3 = n * this._charWidthCache;
        int n4 = n2 * this._heightCache;
        this.drawCursor(n3, n4);
    }

    public synchronized void hideCursor() {
        int n = this._cursorX * this._charWidthCache;
        int n2 = this._cursorY * this._heightCache;
        int n3 = this._charWidthCache;
        int n4 = this._heightCache - 3;
        this._g.setColor(BACKGROUND_COLOR);
        int n5 = this._charWidthCache;
        int n6 = this._heightCache - 3;
        this._g.fillRect(n, n2, n5, n6);
        this._g.setColor(FOREGROUND_COLOR);
        this.repaint(n, n2, n3, n4);
    }

    public void forwardCursor(int n) {
        this.moveCursor(this._cursorX + n, this._cursorY);
    }

    public void moveCursorToCurrentPostion() {
        this.hideCursor();
        this._cursorX = this._currentX / this._charWidthCache;
        this._cursorY = this._currentY / this._heightCache - 1;
        int n = this._currentX;
        int n2 = this._currentY - this._heightCache;
        this.drawCursor(n, n2);
    }

    private synchronized void drawCursor(int n, int n2) {
        int n3 = this._charWidthCache;
        int n4 = this._heightCache - 3;
        this._g.fillRect(n, n2, n3, n4);
        this.repaint(n, n2, n3, n4);
    }

    public void clearLine(int n) {
        this._g.clearRect(0, n * this._heightCache, this.getWidth(), this._heightCache);
        this.repaint();
    }

    public void scrollUp(int n, int n2, int n3, int n4) {
        int n5 = n * this._charWidthCache;
        int n6 = n2 * this._heightCache;
        int n7 = n3 * this._charWidthCache;
        int n8 = this._heightCache;
        this._g.setColor(BACKGROUND_COLOR);
        this._g.fillRect(n5, n6, n7, n8);
        this._g.setColor(FOREGROUND_COLOR);
        int n9 = n * this._charWidthCache;
        int n10 = (n2 + 1) * this._heightCache;
        int n11 = n3 * this._charWidthCache;
        int n12 = n4 * this._heightCache;
        this._g.copyArea(n9, n10, n11, n12, 0, -this._heightCache);
        this.repaint();
    }

    public void error(String string) {
        this.moveTo(1, 23);
        this._g.setColor(ERROR_COLOR);
        this._g.drawString(ERROR_PREFIX + string, this._currentX, this._currentY - this._descentCache);
        int n = this._currentY - this._heightCache;
        int n2 = this._fm.stringWidth(ERROR_PREFIX + string);
        this.repaint(this._currentX, n, n2, this._heightCache);
        this._currentX += n2;
    }

    private void clear(String string, Color color) {
        int n = this._currentY - this._heightCache;
        int n2 = this._fm.stringWidth(string);
        int n3 = this._heightCache;
        this._g.setColor(color);
        this._g.fillRect(this._currentX, n, n2, n3);
        this._g.setColor(FOREGROUND_COLOR);
        this.repaint(this._currentX, n, n2, n3);
    }

    public void startBlock(String string) {
        this._blocker.block(string);
    }

    public void updateBlockMessage(String string) {
        this._blocker.updateMessage(string);
    }

    public void unBlock(String string, long l) {
        this._blocker.unBlock(string, l);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage((Image)this._bufferedImage, 0, 0, this);
    }

    public void drawGuideSpeedLabel(int n) {
        this.moveYTo(23);
        this.drawRevCenterString(" \u8d64\u8272\u306e\u30ab\u30fc\u30bd\u30eb\u306e\u52d5\u304d\u306b\u5408\u308f\u305b\u3066\u3001\u4e00\u5b9a\u306e\u30bf\u30a4\u30df\u30f3\u30b0\u3067\u6253\u3061\u307e\u3057\u3087\u3046\u3002 ");
        this.moveTo(0, 0);
        String string = "\u3010 " + n + " \u30ad\u30fc/\u5206\u3011";
        this.drawString(string, Color.BLACK);
    }

    public void moveSpeedGuideToCurrentPostion() {
        this.hideSpeedGuide();
        this.gx = this._currentX / this._charWidthCache;
        this.gy = this._currentY / this._heightCache - 1;
        this.drawSpeedGuide(this.gx, this.gy);
    }

    public void startSpeedGuide(int n, int n2) {
        System.out.println(this._limitX);
        this._limitX = n2;
        this._speed = n;
        this.guideSpeed = (long)(1000.0 / ((double)n / 60.0));
        System.out.println("Speed:" + n);
        this.timer = new Timer(true);
        MoveSpeedGuideTask moveSpeedGuideTask = new MoveSpeedGuideTask();
        moveSpeedGuideTask.initGx = this.gx;
        this.timer.schedule((TimerTask)moveSpeedGuideTask, 0L, this.guideSpeed);
    }

    public void startSpeedGuide(int n, int n2, int n3) {
        System.out.println(this._limitX);
        this._limitX = n2;
        this._speed = n;
        this.guideSpeed = (long)(1000.0 / ((double)n / 60.0));
        System.out.println("Speed:" + n);
        this.timer = new Timer(true);
        MoveSpeedGuideTask moveSpeedGuideTask = new MoveSpeedGuideTask();
        moveSpeedGuideTask.initGx = n3;
        this.timer.schedule((TimerTask)moveSpeedGuideTask, 0L, this.guideSpeed);
    }

    public void stopSpeedGuide() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void forwardSpeedGuide(int n) {
        this.moveSpeedGuide(this.gx + n, this.gy);
    }

    public void backSpeedGuide(int n) {
        this.moveSpeedGuide(this.gx - n, this.gy);
    }

    public void moveSpeedGuide(int n, int n2) {
        this.hideSpeedGuide();
        this.gx = n;
        this.gy = n2;
        this.drawSpeedGuide(n, n2);
    }

    public synchronized void hideSpeedGuide() {
        int n = this.gx * this._charWidthCache - 2;
        int n2 = this.gy * this._heightCache + this._heightCache - 2;
        int n3 = this._charWidthCache + 4;
        int n4 = 2;
        this._g.setColor(BACKGROUND_COLOR);
        this._g.fillRect(n, n2, n3, n4);
        this._g.setColor(FOREGROUND_COLOR);
        this.repaint(n, n2, n3, n4);
    }

    public synchronized void drawSpeedGuide(int n, int n2) {
        int n3 = n * this._charWidthCache - 2;
        int n4 = n2 * this._heightCache + this._heightCache - 2;
        int n5 = this._charWidthCache + 4;
        int n6 = 2;
        this._g.setColor(Color.RED);
        this._g.fillRect(n3, n4, n5, n6);
        this._g.setColor(FOREGROUND_COLOR);
        this.repaint(n3, n4, n5, n6);
    }

    class MoveSpeedGuideTask
    extends TimerTask {
        int initGx;

        MoveSpeedGuideTask() {
        }

        public void run() {
            if (TWindow.this.gx < TWindow.this._limitX + this.initGx) {
                TWindow.this.forwardSpeedGuide(1);
            }
        }
    }

    private class TWindowAdapter
    extends WindowAdapter {
        private TWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            TWindow.this._application.exit();
        }
    }
}

