/*
 * Decompiled with CFR 0.152.
 */
package tuttt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.JComponent;
import tuttt.TFontManager;
import tuttt.TGlobal;
import tuttt.TNKeyInputHandler;
import tuttt.TTApplication;
import tuttt.TWindow;

public class TWindowBlocker
extends JComponent {
    private static final Font FONT = TFontManager.getDefaultFont();
    private static final Color FOREGROUND_COLOR = Color.BLACK;
    private static final Color BACKGROUND_COLOR = new Color(255, 255, 255, 230);
    private static final int DIALOG_WIDTH = 270;
    private static final int DIALOG_HEIGHT = 140;
    private static final String DEFAULT_MESSAGE;
    private static final String SPINNER_ICON_FILE = "spinner.gif";
    private Image _spinnerIcon;
    private String _message;
    private String _unblockMessage;
    private int _dsx;
    private int _dsy;
    private TWindow _window;
    private boolean _isUnblockMode;

    public TWindowBlocker(TWindow tWindow) {
        this._dsx = (tWindow.getWidth() - 270) / 2;
        this._dsy = (tWindow.getHeight() - 140) / 2 - 25;
        URL uRL = this.getClass().getResource(SPINNER_ICON_FILE);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this._spinnerIcon = toolkit.getImage(uRL);
        this._window = tWindow;
    }

    public void block(String string) {
        this._message = string;
        this.setVisible(true);
    }

    public void updateMessage(String string) {
        this._message = string;
        this.repaint();
    }

    private void initializeGraphics(Graphics2D graphics2D) {
        graphics2D.setFont(FONT);
        graphics2D.setColor(BACKGROUND_COLOR);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (TFontManager.useTrueTypeFont()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    private void drawMessage(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(FOREGROUND_COLOR);
        int n = this._dsx + (270 - fontMetrics.stringWidth(DEFAULT_MESSAGE)) / 2;
        graphics2D.drawString(DEFAULT_MESSAGE, n, this._dsy + 30);
        int n2 = this._dsx + (270 - fontMetrics.stringWidth(this._message)) / 2;
        int n3 = this._dsy + 65;
        graphics2D.drawString(this._message, n2, n3);
    }

    private void drawSpinner(Graphics2D graphics2D) {
        int n = this._spinnerIcon.getWidth(this);
        int n2 = this._spinnerIcon.getHeight(this);
        int n3 = this._dsx + (270 - n) / 2;
        int n4 = 40 + this._dsy + (140 - n2) / 2;
        graphics2D.drawImage(this._spinnerIcon, n3, n4, this);
    }

    public void pause() {
        KeyEvent keyEvent = this._window.getInput();
        if (keyEvent == TNKeyInputHandler.TERMINATE_SIGNAL) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 32: {
                this._isUnblockMode = false;
                return;
            }
        }
        this.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unBlock(String string, long l) {
        try {
            Thread.sleep(l);
            this._unblockMessage = string;
            this._isUnblockMode = true;
            this.repaint();
            this.pause();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        finally {
            this.setVisible(false);
        }
    }

    private void drawUnblockMessage(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(FOREGROUND_COLOR);
        int n = this._dsx + (270 - fontMetrics.stringWidth(this._unblockMessage)) / 2;
        graphics2D.drawString(this._unblockMessage, n, this._dsy + 30);
        String string = TGlobal.getString("pause_message_test");
        int n2 = (this.getWidth() - fontMetrics.stringWidth(string)) / 2;
        int n3 = 400;
        graphics2D.setColor(FOREGROUND_COLOR);
        graphics2D.fillRect(n2, n3 - fontMetrics.getHeight(), fontMetrics.stringWidth(string), fontMetrics.getHeight());
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawString(string, n2, n3 - (fontMetrics.getMaxDescent() + 2));
        graphics2D.setColor(FOREGROUND_COLOR);
        graphics2D.setBackground(BACKGROUND_COLOR);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.initializeGraphics(graphics2D);
        if (this._isUnblockMode) {
            this.drawUnblockMessage(graphics2D);
        } else {
            this.drawMessage(graphics2D);
            this.drawSpinner(graphics2D);
        }
    }

    static {
        switch (TTApplication.LANG) {
            case JA: {
                DEFAULT_MESSAGE = "\u3057\u3070\u3089\u304f\u304a\u5f85\u3061\u304f\u3060\u3055\u3044...";
                break;
            }
            default: {
                DEFAULT_MESSAGE = "Wait a minute...";
            }
        }
    }
}

